package AppGioco;

import AppGioco.QuadroDedicato.*;

public class TipoLinkDedicatoA {
	private final QuadroDedicato ilQuadroDedicato;
	private final Personaggio ilPersonaggio;

	public TipoLinkDedicatoA(QuadroDedicato q, Personaggio p)
			throws EccezionePrecondizioni {
		if (q == null || p == null) // CONTROLLO PRECONDIZIONI
			throw new EccezionePrecondizioni(
					"Gli oggetti devono essere inizializzati");
		ilQuadroDedicato = q;
		ilPersonaggio = p;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkDedicatoA b = (TipoLinkDedicatoA) o;
			return b.ilPersonaggio == ilPersonaggio
					&& b.ilQuadroDedicato == ilQuadroDedicato;
		} else
			return false;
	}

	public int hashCode() {
		return ilQuadroDedicato.hashCode() + ilPersonaggio.hashCode();
	}

	public QuadroDedicato getQuadroDedicato() {
		return ilQuadroDedicato;
	}

	public Personaggio getPersonaggio() {
		return ilPersonaggio;
	}

	public String toString() {
		return "<" + ilQuadroDedicato + ", " + ilPersonaggio + ">";
	}
}
